<x-app-layout>
    <style>
        .no-hover:hover {
            background-color: transparent !important;
        }

        .ck-blurred,
        .ck-focused {
            padding: 1.5rem !important
        }
    </style>

    <div class="demo_main_content_area">
        <div class="vehicled card mt-6 rounded-lg border-none shadow-md ">
            <div class="container-fluid">
                <div class="justify-content-center">
                    <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                        <h4> Header Section</h4>
                    </div>
                    <div class="row p-4 card-body">
                        <div class="col-12">
                            <form action="{{ route('management.web-settings.update', 'header') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="row ">
                                    @php
                                        $header = $webSettings->firstWhere('key', 'header')->decoded_value ?? null;
                                        $menuNameCounter = 0;
                                        $buttonNameCounter = 0;
                                    @endphp
                                    <div class="col-3">
                                        <h1>Logo</h1>
                                        @if ($header && isset($header->logo))
                                            <div class="relative mb-2 w-100 py-2">
                                                <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                                    class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">

                                                    <input id="image" name="logo" type="file" class="hidden"
                                                        accept="image/*" x-ref="image"
                                                        @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                                    <template x-if="imagePreview">
                                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                            style="height: 8rem; width:100%;">

                                                            <img :src="imagePreview" alt="Image Preview"
                                                                class=" rounded object-cover "
                                                                style="height: 8rem;width:100%;" />

                                                            <div
                                                                class="absolute inset-0 z-10 flex items-start justify-end">
                                                                <div class="rounded flex items-center justify-center "
                                                                    style="height: 16%; width:8%; background-color: #fff">
                                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                        alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </template>

                                                    <template x-if="!imagePreview">
                                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                            style="height: 8rem; width:100%;background:black">

                                                            @if ($header && isset($header->logo))
                                                                @php
                                                                    $logoPath = Str::startsWith(
                                                                        $header->logo,
                                                                        'assets/',
                                                                    )
                                                                        ? asset($header->logo)
                                                                        : asset('storage/' . $header->logo);
                                                                @endphp
                                                                <img src="{{ $logoPath }}" alt="Current Avatar"
                                                                    class="object-cover rounded"
                                                                    style="height: 8rem; width: 100%;" />
                                                            @endif

                                                            <div
                                                                class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                <div class="flex items-center justify-center rounded"
                                                                    style="height: 18%; width:8%; background-color: #fff">
                                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                        alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </template>
                                                </div>
                                            </div>
                                        @endif
                                    </div>

                                    <div class="mt-2">
                                        <button class="btn btn-primary">Update</button>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- banner section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4> Banner Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">
                        <form action="{{ route('management.web-settings.update', 'banner') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @php
                                $banner = $webSettings->firstWhere('key', 'banner')->decoded_value ?? null;
                                $imageGroupCounter = 0;
                                $appStoreCounter = 0;
                            @endphp

                            <div class="col-3 mb-4">
                                <label class="form-label">Banner Thumbnail</label>
                                <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                    class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                    <input id="image" name="banner_thumb" type="file" class="hidden"
                                        accept="image/*" x-ref="image"
                                        @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />
                                    <template x-if="imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;">
                                            <img :src="imagePreview" alt="Banner Preview"
                                                class="rounded object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                    <template x-if="!imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;background:black">

                                            @php
                                                $bannerThumb = Str::startsWith($banner->banner_thumb, 'assets/')
                                                    ? asset($banner->banner_thumb)
                                                    : asset('storage/' . $banner->banner_thumb);
                                            @endphp

                                            <img src="{{ $bannerThumb }}" alt="Current Banner"
                                                class="object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6 my-2">
                                        <x-input-label for="banner_title" :value="__('Banner Title')" />
                                        <label for="title" class="form-label">Banner Title</label>
                                        <textarea name="title" id="editor_title" class="form-control" rows="4">{!! $banner->title ?? '' !!}</textarea>
                                    </div>
                                    <div class="col-6 my-2">
                                        <x-input-label for="banner_description" :value="__('Banner Description')" />
                                        <label for="title" class="form-label">Banner Description</label>
                                        <x-textarea name="description" class="form-control" rows="3"
                                            placeholder="Banner Description" :value="old('description', $banner->description ?? '')"></x-textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6 my-2">
                                        <x-input-label for="ratings" :value="__('Ratings')" />
                                        <x-text-input type="number" step="0.1" name="ratings"
                                            class="form-control" placeholder="Ratings (e.g., 4.5)"
                                            value="{{ $banner->ratings ?? '' }}" />
                                    </div>
                                    <div class="col-6 my-2">
                                        <x-input-label for="ratings" :value="__('Ratings')" />
                                        <x-text-input type="text" name="reviews" class="form-control"
                                            placeholder="Reviews (e.g., 10k+ Reviews)"
                                            value="{{ $banner->reviews ?? '' }}" />
                                    </div>
                                </div>

                            </div>
                            <div class="col-12 mt-5">
                                <h5 class="mb-3">Image Group</h5>
                                <div class="row" id="image-group-container">
                                    @if (!empty($banner->image_group))
                                        @foreach ($banner->image_group as $index => $image)
                                            @php $imageGroupCounter = max($imageGroupCounter, $index); @endphp
                                            <div class="col-2 mb-3 image-item ">
                                                <div x-data="{ imagePreview: null }" class="relative border rounded p-3">
                                                    <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                                                        @click="$refs.image.click()">

                                                        <input type="file"
                                                            name="image_group[{{ $index }}][img]"
                                                            class="hidden" accept="image/*" x-ref="image"
                                                            @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                                                        <input type="hidden"
                                                            name="image_group[{{ $index }}][existing_img]"
                                                            value="{{ $image->img ?? '' }}">

                                                        <template x-if="imagePreview">
                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                style="height: 8rem; width:100%;">
                                                                <img :src="imagePreview" alt="Image Preview"
                                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />
                                                                <div
                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                    <div class="rounded flex items-center justify-center"
                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                            alt="">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </template>

                                                        <template x-if="!imagePreview">
                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                style="height: 8rem; width:100%; background:black;">

                                                                @php
                                                                    $imgGroup = Str::startsWith($image->img, 'assets/')
                                                                        ? asset($image->img)
                                                                        : asset('storage/' . $image->img);
                                                                @endphp
                                                                <img src="{{ $imgGroup }}" alt="Existing Image"
                                                                    class="object-cover absolute inset-0 w-100 h-100 rounded" />
                                                                <div
                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                    <div class="rounded flex items-center justify-center"
                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                            alt="">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </template>
                                                    </div>
                                                    <button type="button"
                                                        class="btn btn-outline-danger btn-sm remove-image mt-2 w-100">
                                                        <i class="fa fa-trash"></i> Remove
                                                    </button>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>

                                <div class="d-flex justify-content-end mt-3">
                                    <x-secondary-button type="button" style="width: 9rem" id="add-image-btn">
                                        Add Image
                                    </x-secondary-button>
                                </div>
                            </div>

                            <div class="col-12 mt-2">
                                <h5>App Store Links</h5>
                                <div class="row" id="app-store-container">
                                    @if (!empty($banner->app_store))
                                        @foreach ($banner->app_store as $index => $store)
                                            @php $appStoreCounter = max($appStoreCounter, $index); @endphp
                                            <div class="col-3 my-2 app-store-item">
                                                <div class="mt-2">
                                                    <div class="border rounded p-3 my-2 app-store-item">
                                                        <label>App Store {{ $index + 1 }}</label>
                                                        <div class="input-group mt-2 align-items-start">
                                                            <x-text-input type="text"
                                                                name="app_store[{{ $index }}][link]"
                                                                class="form-control me-2" placeholder="Store Link"
                                                                value="{{ $store->link ?? '' }}"
                                                                style="width: 20rem;" />

                                                            <div class="col-12 image-item">
                                                                <div x-data="{ imagePreview: null }" class="relative">
                                                                    <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                                                                        @click="$refs.image.click()">

                                                                        <input type="file"
                                                                            name="app_store[{{ $index }}][thumb]"
                                                                            accept="image/*" class="hidden"
                                                                            x-ref="image"
                                                                            @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                                                                        <template x-if="imagePreview">
                                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                                style="height: 8rem; width:100%;">
                                                                                <img :src="imagePreview"
                                                                                    alt="App Store Preview"
                                                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />
                                                                                <div
                                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                                    <div class="rounded flex items-center justify-center"
                                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                                            alt="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </template>

                                                                        <template x-if="!imagePreview">
                                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                                style="height: 8rem; width:100%; background:black;">
                                                                                @php
                                                                                    $thumbPath = Str::startsWith(
                                                                                        $store->thumb ?? '',
                                                                                        'assets/',
                                                                                    )
                                                                                        ? asset($store->thumb)
                                                                                        : asset(
                                                                                            'storage/' .
                                                                                                ($store->thumb ?? ''),
                                                                                        );
                                                                                @endphp
                                                                                <img src="{{ $thumbPath }}"
                                                                                    alt="Existing Thumb"
                                                                                    class="object-cover absolute inset-0 w-100 h-100 rounded" />
                                                                                <div
                                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                                    <div class="rounded flex items-center justify-center"
                                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                                            alt="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </template>
                                                                    </div>

                                                                    <button type="button"
                                                                        class="btn btn-outline-danger btn-sm remove-store mt-2 w-100">
                                                                        <i class="fa fa-trash"></i> Remove
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="d-flex justify-content-end mt-3">
                                    <x-secondary-button type="button" style="width: 10rem" id="add-store-btn">Add
                                        Store</x-secondary-button>
                                </div>
                            </div>
                            <div class="mt-2">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- choose section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md">
        <div class="container-fluid">
            <div class="row justify-content-center">

                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Choose Section</h4>
                </div>

                <div class="row p-4 card-body">
                    <div class="col-12">
                        @php
                            $choose = $webSettings->firstWhere('key', 'choose_section')->decoded_value ?? null;
                            $items = $choose->list_item ?? [];
                        @endphp

                        <form action="{{ route('management.web-settings.update', 'choose_section') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="col-3 mb-4">
                                <label class="form-label">Choose Section Thumbnail</label>

                                <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                    class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                    <input id="image" name="choose_thumb" type="file" class="hidden"
                                        accept="image/*" x-ref="image"
                                        @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                    <template x-if="imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;">
                                            <img :src="imagePreview" alt="Banner Preview"
                                                class="rounded object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                    <template x-if="!imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;background:black">

                                            @php
                                                $chooseThumb = Str::startsWith($choose->choose_thumb, 'assets/')
                                                    ? asset($choose->choose_thumb)
                                                    : asset('storage/' . $choose->choose_thumb);
                                            @endphp

                                            <img src="{{ $chooseThumb }}" alt="Current choose section"
                                                class="object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>

                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="choose_editor_title" class="form-control" rows="2">{!! $choose->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="3">{{ $choose->description ?? '' }}</textarea>
                                </div>

                            </div>

                            <div class="col-12 mt-4">
                                <h5 class="pt-3 mb-3">List Items</h5>

                                <div id="list-item-container" class="row">
                                    @foreach ($items as $i => $item)
                                        <div class="col-3 mb-3 list-item">
                                            <div class="border rounded p-3">

                                                <label>Name</label>
                                                <x-text-input type="text" class="form-control mb-2"
                                                    name="list_item[{{ $i }}][name]"
                                                    value="{{ $item->name }}" placeholder="Item name" />

                                                <label>Thumbnail</label>

                                                <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                                    class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                                    <input id="image"
                                                        name="list_item[{{ $i }}][thumb]" type="file"
                                                        class="hidden" accept="image/*" x-ref="image"
                                                        @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                                    <template x-if="imagePreview">
                                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                            style="height: 8rem; width:100%;">
                                                            <img :src="imagePreview" alt="Banner Preview"
                                                                class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                            <div
                                                                class="absolute inset-0 z-10 flex items-start justify-end">
                                                                <div class="rounded flex items-center justify-center "
                                                                    style="height: 16%; width:8%; background-color: #fff">
                                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                        alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </template>
                                                    <template x-if="!imagePreview">
                                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                            style="height: 8rem; width:100%;">

                                                            @php
                                                                $itemThumb = Str::startsWith($item->thumb, 'assets/')
                                                                    ? asset($item->thumb)
                                                                    : asset('storage/' . $item->thumb);
                                                            @endphp

                                                            <img src="{{ $itemThumb }}"
                                                                alt="Current choose section"
                                                                class="object-cover absolute inset-0 w-100 h-100" />

                                                            <div
                                                                class="absolute inset-0 z-10 flex items-start justify-end">
                                                                <div class="rounded flex items-center justify-center "
                                                                    style="height: 16%; width:8%; background-color: #fff">
                                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                        alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </template>
                                                </div>

                                                <button type="button"
                                                    class="btn btn-outline-danger btn-sm w-100 remove-list-item">
                                                    Remove
                                                </button>

                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="d-flex justify-content-end mt-3">
                                    <x-secondary-button type="button" style="width: 10rem"
                                        id="add-list-item-btn">Add
                                        Item</x-secondary-button>
                                </div>
                            </div>

                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- app section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md ">
        <div class="container-fluid">
            <div class="row justify-content-center">

                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>App Section</h4>
                </div>

                <div class="row p-4 card-body">
                    <div class="col-12">

                        @php
                            $app = $webSettings->firstWhere('key', 'app_section')->decoded_value ?? null;
                            $appSectionStoreCounter = 0;
                        @endphp

                        <form action="{{ route('management.web-settings.update', 'app_section') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-3 mb-4">
                                    <label class="form-label">Background Thumbnail</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="background_image" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $appThumb = Str::startsWith($app->background_image, 'assets/')
                                                        ? asset($app->background_image)
                                                        : asset('storage/' . $app->background_image);
                                                @endphp

                                                <img src="{{ $appThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>

                                </div>

                                <div class="col-3 mb-4">
                                    <label class="form-label">App Thumbnail</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="app_thumb" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $appThumb = Str::startsWith($app->app_thumb, 'assets/')
                                                        ? asset($app->app_thumb)
                                                        : asset('storage/' . $app->app_thumb);
                                                @endphp

                                                <img src="{{ $appThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>

                            </div>
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="app_editor_title" class="form-control" rows="2">{!! $app->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="3">{{ $app->description ?? '' }}</textarea>
                                </div>

                            </div>

                            <div class="col-12 mt-2">
                                <h5>App Store Links</h5>
                                <div class="row" id="app-section-store-container">
                                    @if (!empty($app->app_store))
                                        @foreach ($app->app_store as $index => $store)
                                            @php $appSectionStoreCounter = max($appSectionStoreCounter, $index); @endphp
                                            <div class="col-3 my-2 app-section-store-item">
                                                <div class="mt-2">
                                                    <div class="border rounded p-3 my-2 app-section-store-item">
                                                        <label>App Store {{ $index + 1 }}</label>
                                                        <div class="input-group mt-2 align-items-start">
                                                            <x-text-input type="text"
                                                                name="app_section_store[{{ $index }}][link]"
                                                                class="form-control me-2" placeholder="Store Link"
                                                                value="{{ $store->link ?? '' }}"
                                                                style="width: 20rem;" />

                                                            <div class="col-12 image-item">
                                                                <div x-data="{ imagePreview: null }" class="relative">
                                                                    <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                                                                        @click="$refs.image.click()">

                                                                        <input type="file"
                                                                            name="app_section_store[{{ $index }}][thumb]"
                                                                            accept="image/*" class="hidden"
                                                                            x-ref="image"
                                                                            @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                                                                        <template x-if="imagePreview">
                                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                                style="height: 8rem; width:100%;">
                                                                                <img :src="imagePreview"
                                                                                    alt="App Store Preview"
                                                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />
                                                                                <div
                                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                                    <div class="rounded flex items-center justify-center"
                                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                                            alt="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </template>

                                                                        <template x-if="!imagePreview">
                                                                            <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                                                style="height: 8rem; width:100%; background:black;">
                                                                                @php
                                                                                    $thumbPath = Str::startsWith(
                                                                                        $store->thumb ?? '',
                                                                                        'assets/',
                                                                                    )
                                                                                        ? asset($store->thumb)
                                                                                        : asset(
                                                                                            'storage/' .
                                                                                                ($store->thumb ?? ''),
                                                                                        );
                                                                                @endphp
                                                                                <img src="{{ $thumbPath }}"
                                                                                    alt="Existing Thumb"
                                                                                    class="object-cover absolute inset-0 w-100 h-100 rounded" />
                                                                                <div
                                                                                    class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                                                                    <div class="rounded flex items-center justify-center"
                                                                                        style="height: 18%; width:8%; background-color: #fff">
                                                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                                            alt="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </template>
                                                                    </div>

                                                                    <button type="button"
                                                                        class="btn btn-outline-danger btn-sm remove-app-store mt-2 w-100">
                                                                        <i class="fa fa-trash"></i> Remove
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="d-flex justify-content-end mt-3">
                                    <x-secondary-button type="button" style="width: 10rem"
                                        id="add-app-store-btn">Add
                                        Store</x-secondary-button>
                                </div>
                            </div>

                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- feature section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md">
        <div class="container-fluid">
            <div class="row justify-content-center">

                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Feature Section</h4>
                </div>

                <div class="row p-4 card-body">
                    <div class="col-12">

                        @php
                            $feature = $webSettings->firstWhere('key', 'feature_section')->decoded_value ?? null;

                        @endphp

                        <form action="{{ route('management.web-settings.update', 'feature_section') }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="col-3 mb-4">
                                <label class="form-label">Feature Section Thumbnail</label>

                                <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                    class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                    <input id="image" name="background_image" type="file" class="hidden"
                                        accept="image/*" x-ref="image"
                                        @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                    <template x-if="imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;">
                                            <img :src="imagePreview" alt="Banner Preview"
                                                class="rounded object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                    <template x-if="!imagePreview">
                                        <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                            style="height: 8rem; width:100%;background:black">

                                            @php
                                                $featureThumb = Str::startsWith($feature->background_image, 'assets/')
                                                    ? asset($feature->background_image)
                                                    : asset('storage/' . $feature->background_image);
                                            @endphp

                                            <img src="{{ $featureThumb }}" alt="Current choose section"
                                                class="object-cover absolute inset-0 w-100 h-100" />

                                            <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                <div class="rounded flex items-center justify-center "
                                                    style="height: 16%; width:8%; background-color: #fff">
                                                    <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                            </div>


                            {{-- Title --}}
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="feature_editor_title" class="form-control" rows="2">{!! $feature->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <div class="col-12">
                                        <label class="form-label">Sub Title</label>
                                        <textarea name="sub_title" id="feature_editor_sub_title" class="form-control" rows="2">{!! $feature->sub_title ?? '' !!}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Description</label>
                                        <textarea name="description" class="form-control" rows="3">{{ $feature->description ?? '' }}</textarea>
                                    </div>

                                </div>

                            </div>

                            <div class="col-12 mt-4">
                                <h4 class="mb-4">Feature Cards</h4>

                                <div id="feature-card-container" class="row">

                                    @foreach ($feature->feature_card as $i => $card)
                                        <div class="col-3 mb-4 feature-card-item">
                                            <div class="border rounded p-3">
                                                <label>Number</label>
                                                <x-text-input type="number"
                                                    name="feature_card[{{ $i }}][number]"
                                                    value="{{ $card->number }}" class="form-control mb-2" />

                                                <label>Content Title</label>
                                                <x-text-input type="text"
                                                    name="feature_card[{{ $i }}][content_title]"
                                                    value="{{ $card->content_title }}" class="form-control mb-2" />

                                                <label>Content Subtitle</label>
                                                <x-text-input type="text"
                                                    name="feature_card[{{ $i }}][content_subtitle]"
                                                    value="{{ $card->content_subtitle }}"
                                                    class="form-control mb-2" />

                                                <label>Icon Image</label>
                                                <div x-data="{ preview: null }"
                                                    @click="$refs.icon{{ $i }}.click()"
                                                    class="cursor-pointer border rounded p-2 text-center">

                                                    <input type="file"
                                                        name="feature_card[{{ $i }}][icon_image]"
                                                        accept="image/*" class="d-none"
                                                        x-ref="icon{{ $i }}"
                                                        @change="const f=$event.target.files[0]; if(f) preview=URL.createObjectURL(f)">

                                                    <img x-show="preview" :src="preview"
                                                        class="w-100 h-32 object-cover rounded mb-2">

                                                    <img x-show="!preview"
                                                        src="{{ Str::startsWith($card->icon_image, 'assets/')
                                                            ? asset($card->icon_image)
                                                            : asset('storage/' . $card->icon_image) }}"
                                                        class="w-100 h-32 object-cover rounded mb-2">
                                                </div>

                                                <button type="button"
                                                    class="btn btn-outline-danger btn-sm w-100 remove-feature-card mt-2">
                                                    Remove
                                                </button>

                                            </div>
                                        </div>
                                    @endforeach

                                </div>
                                <div class="d-flex justify-content-end mt-3">
                                    <x-secondary-button type="button" style="width: 9rem" id="add-feature-card">
                                        {{ __('Add Card') }}
                                    </x-secondary-button>
                                </div>
                            </div>


                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Discover section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md">
        <div class="container-fluid">
            <div class="row justify-content-center">

                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Discover Section</h4>
                </div>

                <div class="row p-4 card-body">
                    <div class="col-12">

                        @php
                            $discover = $webSettings->firstWhere('key', 'discover_section')->decoded_value ?? null;

                        @endphp

                        <form action="{{ route('management.web-settings.update', 'discover_section') }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            {{-- Thumbnail --}}
                            <div class="row">
                                <div class="col-3 mb-4">
                                    <label class="form-label">Background Image</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="background_image" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $discoverImage = Str::startsWith(
                                                        $discover->background_image,
                                                        'assets/',
                                                    )
                                                        ? asset($discover->background_image)
                                                        : asset('storage/' . $discover->background_image);
                                                @endphp

                                                <img src="{{ $discoverImage }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                                <div class="col-3 mb-4">
                                    <label class="form-label">Discover Thumbnail</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="discover_thumb" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $discoverThumb = Str::startsWith(
                                                        $discover->discover_thumb,
                                                        'assets/',
                                                    )
                                                        ? asset($discover->discover_thumb)
                                                        : asset('storage/' . $discover->discover_thumb);
                                                @endphp

                                                <img src="{{ $discoverThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>

                            </div>

                            {{-- Title --}}
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="discover_editor_title" class="form-control" rows="2">{!! $discover->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="3">{{ $discover->description ?? '' }}</textarea>
                                </div>
                            </div>

                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Who we are section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md ">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Who We Are Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">

                        @php
                            $whoWeAre = $webSettings->firstWhere('key', 'who_we_are')->decoded_value ?? null;
                        @endphp
                        @foreach ($whoWeAre as $who)
                            <form action="{{ route('management.web-settings.update', 'who_we_are') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf

                                <div class=" row mb-4">
                                    <div class="border col-6 p-4">
                                        <div class="mb-4">
                                            <label class="form-label">Title</label>
                                            <textarea name="title_1" id="who_editor_title" class="form-control" rows="2">{{ $who[0]->title_1 ?? '' }}</textarea>
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">Description</label>
                                            <textarea name="description_1" class="form-control" rows="3">{{ $who[0]->description_1 ?? '' }}</textarea>
                                        </div>

                                        <div class="mb-4">
                                            <label class="form-label">Thumbnail</label>
                                            <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                                class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                                <input id="image" name="thumb_1" type="file" class="hidden"
                                                    accept="image/*" x-ref="image"
                                                    @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                                <template x-if="imagePreview">
                                                    <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width: 100%;">
                                                        <img :src="imagePreview" alt="Thumbnail Preview"
                                                            class="rounded object-cover absolute inset-0 w-100 h-100" />
                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center"
                                                                style="height: 16%; width: 8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                                <template x-if="!imagePreview">
                                                    <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width: 100%; background: black;">
                                                        @php
                                                            $thumb_1 = Str::startsWith($who[0]->thumb_1, 'assets/')
                                                                ? asset($who[0]->thumb_1)
                                                                : asset('storage/' . $who[0]->thumb_1);
                                                        @endphp
                                                        <img src="{{ $thumb_1 }}" alt="Current Thumbnail"
                                                            class="object-cover absolute inset-0 w-100 h-100" />
                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center"
                                                                style="height: 16%; width: 8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border col-6 p-4">
                                        <div class="mb-4">
                                            <label class="form-label">Title</label>
                                            <textarea name="title_2" id="who_editor_title1" class="form-control" rows="2">{{ $who[1]->title_2 ?? '' }}</textarea>
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label">Description</label>
                                            <textarea name="description_2" class="form-control" rows="3">{{ $who[1]->description_2 ?? '' }}</textarea>
                                        </div>

                                        <div class="mb-4">
                                            <label class="form-label">Thumbnail</label>
                                            <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                                class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                                <input id="image" name="thumb_2" type="file" class="hidden"
                                                    accept="image/*" x-ref="image"
                                                    @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                                <template x-if="imagePreview">
                                                    <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width: 100%;">
                                                        <img :src="imagePreview" alt="Thumbnail Preview"
                                                            class="rounded object-cover absolute inset-0 w-100 h-100" />
                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center"
                                                                style="height: 16%; width: 8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                                <template x-if="!imagePreview">
                                                    <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width: 100%; background: black;">
                                                        @php
                                                            $thumb_2 = Str::startsWith($who[1]->thumb_2, 'assets/')
                                                                ? asset($who[1]->thumb_2)
                                                                : asset('storage/' . $who[1]->thumb_2);
                                                        @endphp
                                                        <img src="{{ $thumb_2 }}" alt="Current Thumbnail"
                                                            class="object-cover absolute inset-0 w-100 h-100" />
                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center"
                                                                style="height: 16%; width: 8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-3">
                                    <button class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Register section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md ">
        <div class="container-fluid">
            <div class="row justify-content-center">

                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Register Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">

                        @php
                            $register = $webSettings->firstWhere('key', 'register_section')->decoded_value ?? null;
                            $registerNameCounter = 0;
                        @endphp

                        <form action="{{ route('management.web-settings.update', 'register_section') }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            {{-- Thumbnail --}}
                            <div class="row">
                                <div class="col-3 mb-4">
                                    <label class="form-label">Background Image</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="background_image" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $registerImage = Str::startsWith(
                                                        $register->background_image,
                                                        'assets/',
                                                    )
                                                        ? asset($register->background_image)
                                                        : asset('storage/' . $register->background_image);
                                                @endphp

                                                <img src="{{ $registerImage }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                                <div class="col-3 mb-4">
                                    <label class="form-label">Register Thumbnail</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="register_thumb" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Banner Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $registerThumb = Str::startsWith($register->thumb, 'assets/')
                                                        ? asset($register->thumb)
                                                        : asset('storage/' . $register->thumb);
                                                @endphp

                                                <img src="{{ $registerThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>

                            </div>

                            {{-- Title --}}
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="register_editor_title" class="form-control" rows="2">{!! $register->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Sub Title</label>
                                        <x-text-input type="text" class="form-control" name="sub_title"
                                            value="{{ $register->sub_title ?? '' }}" placeholder="Menu name" />

                                    </div>
                                    <div class="col-12">
                                        <label class="form-label">Description</label>
                                        <textarea name="description" class="form-control" rows="3">{{ $register->description ?? '' }}</textarea>
                                    </div>
                                </div>

                            </div>
                            <div class="row" id="register-button-container">
                                @foreach ($register->button as $button)
                                    @php
                                        $buttonNameKey = collect($button)
                                            ->keys()
                                            ->first(fn($key) => Str::startsWith($key, 'button_name_'));
                                        $buttonLinkKey = collect($button)
                                            ->keys()
                                            ->first(fn($key) => Str::startsWith($key, 'button_link_'));
                                        $registerButtonNameCounter = max(
                                            $registerNameCounter,
                                            (int) filter_var($buttonNameKey, FILTER_SANITIZE_NUMBER_INT),
                                        );
                                    @endphp

                                    <div class="col-6 my-2 register-button-item">
                                        <label for="{{ $buttonNameKey }}">{{ $buttonNameKey }}</label>
                                        <div class="input-group mt-2">
                                            <x-text-input type="text" class="form-control"
                                                name="{{ $buttonNameKey }}" id="{{ $buttonNameKey }}"
                                                value="{{ $button->$buttonNameKey ?? '' }}"
                                                placeholder="Menu name" />

                                            <x-text-input type="text" class="form-control" style="width:20rem"
                                                name="{{ $buttonLinkKey }}" id="{{ $buttonLinkKey }}"
                                                value="{{ $button->$buttonLinkKey ?? '' }}"
                                                placeholder="Menu link" />

                                            <button type="button"
                                                class="btn btn-outline-danger remove-register-button no-hover">
                                                <i class="fa fa-trash" style="color:red; width:14px"></i></button>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" style="width: 10rem" id="add-register-button-btn">
                                    {{ __('Add button') }}
                                </x-secondary-button>
                            </div>
                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- for testimonial section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md ">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Testimonial Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">
                        @php
                            $testimonial =
                                $webSettings->firstWhere('key', 'testimonial_section')->decoded_value ?? null;
                        @endphp

                        <form action="{{ route('management.web-settings.update', 'testimonial_section') }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            {{-- Title --}}
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="testimonial_editor_title" class="form-control" rows="2">{!! $testimonial->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="3">{{ $testimonial->description ?? '' }}</textarea>

                                </div>
                            </div>

                            <div class="row my-4">
                                <div class="col-12">
                                    <h4>User Testimonials</h4>
                                </div>
                            </div>

                            <div class="row" id="testimonial-container">
                                @foreach ($testimonial->testimonial_content as $i => $testimonialData)
                                    @php
                                        $nameField = 'title_' . ($i + 1);
                                        $ratingField = 'rating_' . ($i + 1);
                                        $avatarField = 'avatar_image_' . ($i + 1);
                                        $dateField = 'date_' . ($i + 1);
                                        $descriptionField = 'description_' . ($i + 1);
                                        $formattedDate = \Carbon\Carbon::parse($testimonialData->{$dateField})->format(
                                            'Y-m-d',
                                        );
                                    @endphp

                                    <div class="col-4 mb-4 testimonial-item"
                                        id="testimonial-item-{{ $i }}">
                                        <div class="border rounded p-3">
                                            <!-- Name (Title) -->
                                            <label>Name</label>
                                            <x-text-input type="text"
                                                name="testimonial_content[{{ $i }}][{{ $nameField }}]"
                                                value="{{ $testimonialData->{$nameField} }}"
                                                class="form-control mb-2" placeholder="Testimonial Name" />

                                            <!-- Rating -->
                                            <label>Rating</label>
                                            <x-text-input type="number"
                                                name="testimonial_content[{{ $i }}][{{ $ratingField }}]"
                                                value="{{ $testimonialData->{$ratingField} }}"
                                                class="form-control mb-2" placeholder="Rating (1-5)" />

                                            <!-- Date -->
                                            <label>Date</label>
                                            <x-text-input type="date"
                                                name="testimonial_content[{{ $i }}][{{ $dateField }}]"
                                                value="{{ $formattedDate }}" class="form-control mb-2"
                                                placeholder="Date" />

                                            <!-- Description -->
                                            <label>Description</label>
                                            <textarea name="testimonial_content[{{ $i }}][{{ $descriptionField }}]" class="form-control mb-2"
                                                rows="3">{{ $testimonialData->{$descriptionField} }}</textarea>

                                            <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                                class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                                <input id="image"
                                                    name="testimonial_content[{{ $i }}][{{ $avatarField }}]"
                                                    type="file" class="hidden" accept="image/*" x-ref="image"
                                                    @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                                <template x-if="imagePreview">
                                                    <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width:100%;">
                                                        <img :src="imagePreview" alt="Banner Preview"
                                                            class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center "
                                                                style="height: 16%; width:8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                                <template x-if="!imagePreview">
                                                    <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                        style="height: 8rem; width:100%;background:black">

                                                        @php
                                                            $testimonialThumb = Str::startsWith(
                                                                $testimonialData->{$avatarField},
                                                                'assets/',
                                                            )
                                                                ? asset($testimonialData->{$avatarField})
                                                                : asset('storage/' . $testimonialData->{$avatarField});
                                                        @endphp

                                                        <img src="{{ $testimonialThumb }}"
                                                            alt="Current choose section"
                                                            class="object-cover absolute inset-0 w-100 h-100" />

                                                        <div
                                                            class="absolute inset-0 z-10 flex items-start justify-end">
                                                            <div class="rounded flex items-center justify-center "
                                                                style="height: 16%; width:8%; background-color: #fff">
                                                                <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                    alt="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>

                                            @if ($i >= 0)
                                                <div>
                                                    <button type="button"
                                                        class="btn btn-outline-danger remove-testimonial mt-2 w-100"
                                                        onclick="removeTestimonial({{ $i }})">Remove</button>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" style="width: 12rem" id="add-testimonial-btn">
                                    {{ __('Add Testimonial') }}
                                </x-secondary-button>

                            </div>
                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- for accordian section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Accordian Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">
                        @php
                            $accordian = $webSettings->firstWhere('key', 'accordian_section')->decoded_value ?? null;
                        @endphp

                        <form action="{{ route('management.web-settings.update', 'accordian_section') }}"
                            method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-3 mb-4">
                                    <label class="form-label">Accordian Thumbnail</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="accordian_thumb" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Accordian Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $accordianThumb = Str::startsWith(
                                                        $accordian->accordian_thumb,
                                                        'assets/',
                                                    )
                                                        ? asset($accordian->accordian_thumb)
                                                        : asset('storage/' . $accordian->accordian_thumb);
                                                @endphp

                                                <img src="{{ $accordianThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>

                            {{-- Title --}}
                            <div class="row my-2">
                                <div class="col-6">
                                    <label class="form-label">Title</label>
                                    <textarea name="title" id="accordian_editor_title" class="form-control" rows="2">{!! $accordian->title ?? '' !!}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Sub Title</label>
                                    <textarea name="sub_title" class="form-control" rows="3">{{ $accordian->sub_title ?? '' }}</textarea>
                                </div>
                            </div>


                            <div class="row" id="accordian-container">
                                @foreach ($accordian->accordian_items as $i => $accordianData)
                                    @php
                                        $titleField = 'title_' . ($i + 1);
                                        $contentField = 'content_' . ($i + 1);

                                    @endphp

                                    <div class="col-4 mb-4 accordian-item"
                                        id="accordian-item-{{ $i }}">
                                        <div class="border rounded p-3">
                                            <!-- Name (Title) -->
                                            <label>Title</label>
                                            <x-text-input type="text"
                                                name="accordian_items[{{ $i }}][title]"
                                                value="{{ $accordianData->{$titleField} }}"
                                                class="form-control mb-2" placeholder="Accordian Title" />

                                            <!-- Content -->
                                            <label>Content</label>
                                            <textarea name="accordian_items[{{ $i }}][content]" class="form-control" rows="3">{{ $accordianData->{$contentField} ?? '' }}</textarea>


                                            @if ($i >= 0)
                                                <div>
                                                    <button type="button"
                                                        class="btn btn-outline-danger remove-accordian mt-2 w-100"
                                                        onclick="removeAccordian({{ $i }})">Remove</button>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" style="width: 12rem" id="add-accordian-btn">
                                    {{ __('Add Accordian') }}
                                </x-secondary-button>

                            </div>
                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- for footer section --}}
    <div class="vehicled card mt-6 rounded-lg border-none shadow-md mb-120">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="card-header py-3 d-flex align-items-center bg-primary text-white">
                    <h4>Footer Section</h4>
                </div>
                <div class="row p-4 card-body">
                    <div class="col-12">
                        @php
                            $footer = $webSettings->firstWhere('key', 'footer')->decoded_value ?? null;
                        @endphp


                        <form action="{{ route('management.web-settings.update', 'footer') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-3 mb-4">
                                    <label class="form-label">Footer Logo</label>

                                    <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                                        class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                                        <input id="image" name="footer_logo" type="file" class="hidden"
                                            accept="image/*" x-ref="image"
                                            @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                                        <template x-if="imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;">
                                                <img :src="imagePreview" alt="Accordian Preview"
                                                    class="rounded object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!imagePreview">
                                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                                style="height: 8rem; width:100%;background:black">

                                                @php
                                                    $footerThumb = Str::startsWith($footer->footer_logo, 'assets/')
                                                        ? asset($footer->footer_logo)
                                                        : asset('storage/' . $footer->footer_logo);
                                                @endphp

                                                <img src="{{ $footerThumb }}" alt="Current choose section"
                                                    class="object-cover absolute inset-0 w-100 h-100" />

                                                <div class="absolute inset-0 z-10 flex items-start justify-end">
                                                    <div class="rounded flex items-center justify-center "
                                                        style="height: 16%; width:8%; background-color: #fff">
                                                        <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <label class="form-label">Description</label>
                                    <textarea name="description" class="form-control" rows="3">{{ $footer->description ?? '' }}</textarea>
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Footer text</label>
                                    <x-text-input type="text" class="form-control" name="footer_text"
                                        value="{{ $footer->footer_text ?? '' }}" placeholder="footer name" />

                                </div>
                            </div>
                            <div class="row" id="footer-link-container">
                                @foreach ($footer->footer_link as $i => $link)
                                    @php
                                        $linkField = 'link_' . ($i + 1);
                                        $contentField = 'content_' . ($i + 1);
                                        $footerLinkCounter = 0;
                                    @endphp

                                    <div class="col-6 my-2 footer-item">
                                        <label for="{{ $linkField }}">Footer Link</label>
                                        <div class="input-group mt-2">
                                            <x-text-input type="text" class="form-control"
                                                name="footer_link[{{ $i }}][link]"
                                                value="{{ $link->$linkField ?? '' }}" placeholder="footer name" />

                                            <x-text-input type="text" class="form-control" style="width:20rem"
                                                name="footer_link[{{ $i }}][content]"
                                                value="{{ $link->$contentField ?? '' }}"
                                                placeholder="Footer link" />

                                            <button type="button"
                                                class="btn btn-outline-danger remove-link no-hover">
                                                <i class="fa fa-trash" style="color:red; width:14px"></i></button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>



                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" style="width: 12rem" id="add-footer-link">
                                    {{ __('Add footer link') }}
                                </x-secondary-button>

                            </div>


                            <div class="row" id="footer-icon-container">
                                <h5>Social Icons</h5>

                                @foreach ($footer->social_icon as $i => $iconItem)
                                    @php
                                        $iconKey = 'icon_' . ($i + 1);
                                        $linkKey = 'link_icon_' . ($i + 1);

                                        $iconPath = Str::startsWith($iconItem->$iconKey, 'assets/')
                                            ? asset($iconItem->$iconKey)
                                            : asset('storage/' . $iconItem->$iconKey);
                                    @endphp

                                    <div class="col-3 my-2 footer-link" id="footer-icon-{{ $i }}">
                                        <div class="border rounded p-3">

                                            <label>Social Link</label>
                                            <x-text-input type="text"
                                                name="social_icon[{{ $i }}][{{ $linkKey }}]"
                                                class="form-control mb-2"
                                                value="{{ $iconItem->$linkKey ?? '#' }}" />

                                            {{-- Icon Upload --}}
                                            <div x-data="{ imagePreview: null }"
                                                @click="$refs.image{{ $i }}.click()"
                                                class="ant-upload ant-upload-select-picture-card flex justify-center items-center cursor-pointer relative h-32 w-100">

                                                <input type="file"
                                                    name="social_icon[{{ $i }}][{{ $iconKey }}]"
                                                    class="hidden" accept="image/*"
                                                    x-ref="image{{ $i }}"
                                                    @change="const f = $event.target.files[0]; if (f) imagePreview = URL.createObjectURL(f)" />

                                                <template x-if="imagePreview">
                                                    <div class="absolute inset-0 bg-black">
                                                        <img :src="imagePreview"
                                                            class="absolute inset-0 object-cover w-100 h-100 rounded" />

                                                        <div class="absolute top-0 right-0 m-1 bg-white p-1 rounded">
                                                            <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                alt="">
                                                        </div>
                                                    </div>

                                                </template>

                                                <template x-if="!imagePreview ">
                                                    <div class="absolute inset-0 bg-black">
                                                        <img src="{{ $iconPath }}"
                                                            class="absolute inset-0 object-cover w-100 h-100 rounded" />

                                                        <div class="absolute top-0 right-0 m-1 bg-white p-1 rounded">
                                                            <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                alt="">
                                                        </div>
                                                    </div>

                                                </template>
                                            </div>

                                            <button type="button" class="btn btn-outline-danger w-100 mt-2"
                                                onclick="removeFooterIcon({{ $i }})">
                                                Remove
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>


                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" id="add-footer-icon" style="width: 12rem">
                                    Add footer icon
                                </x-secondary-button>
                            </div>

                            <div class="row" id="footer-link-container2">

                                @foreach ($footer->link as $i => $link)
                                    <div class="col-3 mb-4 footer-link-item" id="footer-link-{{ $i }}">
                                        <div class="border rounded p-3">

                                            @php
                                                $linkKey = 'link_' . ($i + 1);
                                                $linkPath = 'link_icon_' . ($i + 1);

                                                $iconPath = Str::startsWith($link->$linkPath, 'assets/')
                                                    ? asset($link->$linkPath)
                                                    : asset('storage/' . $link->$linkPath);
                                            @endphp

                                            <label>Contact Link</label>

                                            <x-text-input type="text"
                                                name="link[{{ $i }}][{{ $linkKey }}]"
                                                class="form-control mb-2" value="{{ $link->$linkKey ?? '#' }}" />



                                            <label>Icon Image</label>
                                            <div x-data="{ imagePreview: null }"
                                                @click="$refs.image{{ $i }}.click()"
                                                class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">

                                                <input type="file"
                                                    name="link[{{ $i }}][link_icon_{{ $i + 1 }}]"
                                                    class="hidden" accept="image/*"
                                                    x-ref="image{{ $i }}"
                                                    @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                                                {{-- Preview new uploaded image --}}
                                                <template x-if="imagePreview">
                                                    <div class="absolute inset-0 bg-black">
                                                        <img :src="imagePreview"
                                                            class="rounded object-cover w-100 h-100" />

                                                        <div class="absolute top-0 right-0 m-1 bg-white p-1 rounded">
                                                            <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                alt="">
                                                        </div>
                                                    </div>
                                                </template>

                                                {{-- Show existing stored image --}}
                                                <template x-if="!imagePreview">
                                                    <div class="absolute inset-0 bg-black">
                                                        <img src="{{ $iconPath }}"
                                                            class="rounded object-cover w-100 h-100" />

                                                        <div class="absolute top-0 right-0 m-1 bg-white p-1 rounded">
                                                            <img src="{{ asset('assets/images/image-plus.svg') }}"
                                                                alt="">
                                                        </div>
                                                    </div>
                                                </template>

                                            </div>

                                            {{-- Remove --}}
                                            <button type="button" class="btn btn-outline-danger btn-sm w-100 mt-2"
                                                onclick="removeFooterLink({{ $i }})">
                                                Remove
                                            </button>

                                        </div>
                                    </div>
                                @endforeach


                            </div>


                            <div class="d-flex justify-content-end mt-3">
                                <x-secondary-button type="button" style="width: 9rem" id="add-link">
                                    {{ __('Add Link') }}
                                </x-secondary-button>

                            </div>

                            <div class="mt-3">
                                <button class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


</x-app-layout>
<script src="https://cdn.ckeditor.com/ckeditor5/41.0.0/classic/ckeditor.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const editorConfig = {
            toolbar: [
                'undo', 'redo', '|',
                'bold', 'italic', 'underline', '|',
                'link', 'bulletedList', 'numberedList', '|',
                'heading', 'fontColor', '|',
                'alignment', 'removeFormat'
            ]
        };

        function initCKEditors(selectors = []) {
            selectors.forEach(selector => {
                const element = document.querySelector(selector);

                if (element) {
                    ClassicEditor
                        .create(element, editorConfig)
                        .then(editor => console.log(`CKEditor initialized for ${selector}`, editor))
                        .catch(error => console.error(`CKEditor error for ${selector}:`, error));
                } else {
                    console.warn(`CKEditor skipped: ${selector} not found`);
                }
            });
        }

        initCKEditors([
            '#editor_title',
            '#choose_editor_title',
            '#app_editor_title',
            '#feature_editor_title',
            '#discover_editor_title',
            '#who_editor_title',
            '#who_editor_title1',
            '#register_editor_title',
            '#testimonial_editor_title',
            '#accordian_editor_title',
        ]);

    });

    // for banner section
    document.addEventListener('DOMContentLoaded', () => {
        let imageCount = {{ $imageGroupCounter ?? 0 }};
        const container = document.getElementById('image-group-container');
        document.getElementById('add-image-btn')?.addEventListener('click', () => {
            imageCount++;
            const item = document.createElement('div');
            item.classList.add('col-2', 'mb-3', 'image-item');
            item.innerHTML = `
            <div x-data="{ imagePreview: null }" class="relative border rounded p-3">
                <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview" @click="$refs.image.click()">
                    <input type="file" name="image_group[${imageCount}][img]" class="hidden" accept="image/*" x-ref="image"
                        @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />
                    <template x-if="imagePreview">
                        <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                             style="height: 8rem; width:100%;">
                            <img :src="imagePreview" alt="Image Preview" class="rounded object-cover absolute inset-0 w-100 h-100" />
                            <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                <div class="rounded flex items-center justify-center"
                                    style="height: 18%; width:8%; background-color: #fff">
                                    <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                </div>
                            </div>
                        </div>
                    </template>
                    <template x-if="!imagePreview">
                        <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                             style="height: 8rem; width:100%; background:black;">
                            <span class="text-white">Click to upload</span>
                        </div>
                    </template>
                </div>
                <button type="button" class="btn btn-outline-danger btn-sm remove-image mt-2 w-100">
                    <i class="fa fa-trash"></i> Remove
                </button>
            </div>`;
            container.appendChild(item);
            Alpine.initTree(item); // reinitialize Alpine for new items
        });

        document.addEventListener('click', (e) => {
            if (e.target.closest('.remove-image')) {
                e.target.closest('.image-item').remove();
            }
        });
    });
    // for banner section app store
    document.addEventListener('DOMContentLoaded', () => {
        let storeCount = {{ $appStoreCounter ?? 0 }};
        const container = document.getElementById('app-store-container');

        document.getElementById('add-store-btn')?.addEventListener('click', () => {
            storeCount++;

            const item = document.createElement('div');
            item.classList.add('col-3', 'my-2', 'app-store-item');

            item.innerHTML = `
                <div class="mt-2 border rounded p-3">
            <label>App Store ${storeCount + 1}</label>
            <div class="input-group mt-2 align-items-start">
                <!-- App Store Link -->
                <x-text-input type="text"
                    name="app_store[${storeCount}][link]"
                    class="form-control me-2"
                    placeholder="Store Link"
                    style="width: 20rem;" />

                <!-- Image Upload (with preview) -->
                <div class="col-12 image-item">
                    <div x-data="{ imagePreview: null }" class="relative">
                        <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                            @click="$refs.image.click()">

                            <!-- Hidden File Input -->
                            <input type="file"
                                name="app_store[${storeCount}][thumb]"
                                accept="image/*"
                                class="hidden"
                                x-ref="image"
                                @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                            <!-- Image Preview (new upload) -->
                            <template x-if="imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%;">
                                    <img :src="imagePreview"
                                        alt="App Store Preview"
                                        class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <!-- Placeholder (no image yet) -->
                            <template x-if="!imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>

                        <!-- Remove Button -->
                        <button type="button"
                            class="btn btn-outline-danger btn-sm remove-store mt-2 w-100">
                            <i class="fa fa-trash"></i> Remove
                        </button>
                    </div>
                </div>
            </div></div>
        `;

            container.appendChild(item);
            Alpine.initTree(item);
        });

        document.addEventListener('click', (e) => {
            if (e.target.closest('.remove-store')) {
                e.target.closest('.app-store-item').remove();
            }
        });
    });


    // for choose section
    document.addEventListener("DOMContentLoaded", () => {
        let index = {{ count($items) }};
        document.getElementById("add-list-item-btn").addEventListener("click", () => {
            let container = document.getElementById("list-item-container");

            container.insertAdjacentHTML("beforeend", `
            <div class="col-3 mb-3 list-item">
                <div class="border rounded p-3">

                    <label>Name</label>
                    <x-text-input type="text" class="form-control mb-2"
                           name="list_item[${index}][name]"
                           placeholder="Item name" />

                    <label>Thumbnail</label>

                    <div x-data="{ preview: null }"
                         @click="$refs.img${index}.click()"
                         class="cursor-pointer position-relative">

                        <input type="file" class="d-none"
                               name="list_item[${index}][thumb]"
                               accept="image/*"
                               x-ref="img${index}"
                               @change="let f=$event.target.files[0]; if(f) preview=URL.createObjectURL(f)">

                        <template x-if="preview">
                                <div class="z-10 mt-2 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%;">
                                    <img :src="imagePreview"
                                        alt="App Store Preview"
                                        class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <!-- Placeholder (no image yet) -->
                            <template x-if="!preview">
                                <div class="z-10 text-black mt-2 rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>
                    </div>


                    <button type="button"
                            class="btn btn-outline-danger btn-sm w-100 remove-list-item mt-2">
                        Remove
                    </button>
                </div>
            </div>
        `);
            index++;
        });

        // Remove item
        document.addEventListener("click", e => {
            if (e.target.closest(".remove-list-item")) {
                e.target.closest(".list-item").remove();
            }
        });
    });

    // for app section
    document.addEventListener('DOMContentLoaded', () => {
        let appStoreCount = {{ $appSectionStoreCounter ?? 0 }};
        const appContainer = document.getElementById('app-section-store-container');

        document.getElementById('add-app-store-btn')?.addEventListener('click', () => {
            appStoreCount++;

            const appItem = document.createElement('div');
            appItem.classList.add('col-3', 'my-2', 'app-section-store-item');

            appItem.innerHTML = `
                <div class="mt-2 border rounded p-3">
            <label>App Store ${appStoreCount + 1}</label>
            <div class="input-group mt-2 align-items-start">
                <!-- App Store Link -->
                <x-text-input type="text"
                    name="app_section_store[${appStoreCount}][link]"
                    class="form-control me-2"
                    placeholder="Store Link"
                    style="width: 20rem;" />

                <!-- Image Upload (with preview) -->
                <div class="col-12 image-item">
                    <div x-data="{ imagePreview: null }" class="relative">
                        <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                            @click="$refs.image.click()">

                            <!-- Hidden File Input -->
                            <input type="file"
                                name="app_section_store[${appStoreCount}][thumb]"
                                accept="image/*"
                                class="hidden"
                                x-ref="image"
                                @change="const file = $event.target.files[0]; if (file) imagePreview = URL.createObjectURL(file)" />

                            <!-- Image Preview (new upload) -->
                            <template x-if="imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%;">
                                    <img :src="imagePreview"
                                        alt="App Store Preview"
                                        class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <!-- Placeholder (no image yet) -->
                            <template x-if="!imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>

                        <!-- Remove Button -->
                        <button type="button"
                            class="btn btn-outline-danger btn-sm remove-store mt-2 w-100">
                            <i class="fa fa-trash"></i> Remove
                        </button>
                    </div>
                </div>
            </div></div>
        `;

            appContainer.appendChild(appItem);
            Alpine.initTree(appItem);
        });

        document.addEventListener('click', (e) => {
            if (e.target.closest('.remove-app-store')) {
                e.target.closest('.app-section-store-item').remove();
            }
        });
    });


    // for feature section
    let featureIndex = {{ count($feature->feature_card) }};
    $('#add-feature-card').on('click', function() {
        let html = `
        <div class="col-3 mb-4 feature-card-item">
            <div class="border rounded p-3">
                <label>Number</label>
                <x-text-input type="number" name="feature_card[${featureIndex}][number]" class="form-control mb-2" />

                <label>Content Title</label>
                <x-text-input type="text" name="feature_card[${featureIndex}][content_title]" class="form-control mb-2" />

                <label>Content Subtitle</label>
                <x-text-input type="text" name="feature_card[${featureIndex}][content_subtitle]" class="form-control mb-2" />

                <label>Icon Image</label>
                <div class="col-12 image-item">
                    <div x-data="{ featureImagePreview: null }" class="relative">
                        <div class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview"
                            @click="$refs.image.click()">

                            <!-- Hidden File Input -->
                            <input type="file"
                                name="feature_card[${featureIndex}][icon_image]"
                                accept="image/*"
                                class="hidden"
                                x-ref="image"
                                @change="const file = $event.target.files[0]; if (file) featureImagePreview = URL.createObjectURL(file)" />

                            <!-- Image Preview (new upload) -->
                            <template x-if="featureImagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%;">
                                    <img :src="featureImagePreview"
                                        alt="App Store Preview"
                                        class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src="{{ asset('assets/images/image-plus.svg') }}" alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>

                            <!-- Placeholder (no image yet) -->
                            <template x-if="!featureImagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src="{{ asset('assets/images/image-plus.svg') }}" alt="">
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>
                        <!-- Remove Button -->
                        <button type="button" class="btn btn-outline-danger btn-sm w-100 remove-feature-card mt-2">
                            Remove
                        </button>
                    </div>
                </div>
            </div>
        </div>
        `;

        $('#feature-card-container').append(html);

        featureIndex++;
    });
    // Removing a feature card for feature section
    $(document).on('click', '.remove-feature-card', function() {
        $(this).closest('.feature-card-item').remove();
    });


    // for register section
    let registerButtonCounter = {{ $registerButtonNameCounter }};
    const registeruttonContainer = document.getElementById('register-button-container');
    document.getElementById('add-register-button-btn').addEventListener('click', function() {
        registerButtonCounter++;

        const div = document.createElement('div');
        div.classList.add('col-6', 'my-2', 'register-button-item');

        div.innerHTML = `
            <label for="button_name_${registerButtonCounter}">button_name_${registerButtonCounter}</label>
            <div class="input-group mt-2">
                <x-text-input type="text" class="form-control" name="button_name_${registerButtonCounter}" id="button_name_${registerButtonCounter}" placeholder="Button name" />
                <x-text-input type="text" class="form-control" style="width:20rem" name="button_link_${registerButtonCounter}" id="button_name_link_${registerButtonCounter}" placeholder="Button link" />
                <button type="button" class="btn btn-outline-danger remove-register-button no-hover"><i class="fa fa-trash" style="color:red; width:14px"></i></button>
            </div>
        `;

        registeruttonContainer.appendChild(div);
    });
    // Removing a menu for register section
    registeruttonContainer.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('remove-register-button')) {
            const registerItem = e.target.closest('.register-button-item');
            if (registerItem) registerItem.remove();
        }
    });


    // For testimonial section
    document.getElementById('add-testimonial-btn').addEventListener('click', function() {
        const testimonialContainer = document.getElementById('testimonial-container');

        const index = testimonialContainer.children.length + 2;

        const newTestimonial = document.createElement('div');
        newTestimonial.classList.add('col-md-4', 'mb-4', 'testimonial-item');
        newTestimonial.id = `testimonial-item-${index}`;

        newTestimonial.innerHTML = `
            <div class="testimonial-item border rounded p-3">

                <!-- Name (Title) -->
                <label>Title</label>
                <x-text-input type="text" name="testimonial_content[${index}][title_${index}]"
                    class="form-control mb-2" placeholder="Name" />

                <!-- Rating (Stars) -->
                <label>Rating</label>
                <x-text-input type="number" name="testimonial_content[${index}][rating_${index}]"
                    class="form-control mb-2" placeholder="Rating" />

                <!-- Date -->
                <label>Date</label>
                <x-text-input type="date" name="testimonial_content[${index}][date_${index}]"
                    class="form-control mb-2" />

                <!-- Description -->
                <label>Description</label>
                <textarea name="testimonial_content[${index}][description_${index}]" class="form-control mb-2" placeholder="Testimonial Description"></textarea>

                 <div x-data="{ imagePreview: null }" @click="$refs.image.click()" class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                    <input id="image" name="testimonial_content[${index}][avatar_image_${index}]" type="file"class="hidden" accept="image/*" x-ref="image" @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                        <template x-if="imagePreview">
                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative" style="height: 8rem; width:100%;">
                                <img :src="imagePreview" alt="Banner Preview" class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end">
                                        <div class="rounded flex items-center justify-center " style="height: 16%; width:4%; background-color: #fff">
                                            <img src="{{ asset('assets/images/image-plus.svg') }}" alt="">
                                    </div>
                                </div>
                            </div>
                        </template>
                        <template x-if="!imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                        </template>
                </div>

                <!-- Remove Button -->
                <button type="button" class="btn btn-outline-danger remove-testimonial  mt-2 w-100" onclick="removeTestimonial(${index})">Remove</button>
            </div>
        `;

        // Append the new testimonial to the container
        testimonialContainer.appendChild(newTestimonial);
    });
    // removing a testimonial item for testimonial section
    function removeTestimonial(index) {
        const testimonialItem = document.getElementById(`testimonial-item-${index}`);
        if (testimonialItem) {
            testimonialItem.remove();
        }
    }


    // Function to handle adding a new accordian
    document.getElementById('add-accordian-btn').addEventListener('click', function() {
        const accordianContainer = document.getElementById('accordian-container');

        const index = accordianContainer.children.length;

        const newAccordian = document.createElement('div');
        newAccordian.classList.add('col-md-4', 'mb-4', 'accordian-item');
        newAccordian.id = `accordian-item-${index}`;

        newAccordian.innerHTML = `
            <div class="accordian-item border rounded p-3">

                <!-- Name (Title) -->
                <label>Title</label>
                <x-text-input type="text" name="accordian_items[${index}][title]"
                    class="form-control mb-2" placeholder="Name" />

                <!-- Description -->
                <label>Content</label>
                <textarea name="accordian_items[${index}][content]" class="form-control mb-2" placeholder="Testimonial Description"></textarea>



                <!-- Remove Button -->
                <button type="button" class="btn btn-outline-danger remove-accordian  mt-2 w-100" onclick="removeAccordian(${index})">Remove</button>
            </div>
        `;

        // Append the new testimonial to the container
        accordianContainer.appendChild(newAccordian);
    });

    // Function to handle removing a accordian item
    function removeAccordian(index) {
        const accordianItem = document.getElementById(`accordian-item-${index}`);
        if (accordianItem) {
            accordianItem.remove();
        }
    }


    // For footer section
    let footerLinkCounter = {{ $footerLinkCounter }};
    const footerContainer = document.getElementById('footer-link-container');

    // Add footer link on click
    document.getElementById('add-footer-link').addEventListener('click', function() {
        footerLinkCounter++;

        // Create new div for the new footer link
        const div = document.createElement('div');
        div.classList.add('col-6', 'my-2', 'footer-item');
        div.id = 'footer-item-' + footerLinkCounter;
        div.innerHTML = `
            <label for="footer_link[${footerLinkCounter}][link]">Footer Link</label>
            <div class="input-group mt-2">
                <x-text-input type="text" class="form-control"
                    name="footer_link[${footerLinkCounter}][link]"
                    placeholder="Footer Name" />
                <x-text-input type="text" class="form-control" style="width:20rem"
                    name="footer_link[${footerLinkCounter}][content]"
                    placeholder="Footer Link" />
                <button type="button" class="btn btn-outline-danger remove-link no-hover">
                    <i class="fa fa-trash" style="color:red; width:14px"></i>
                </button>
            </div>
        `;
        footerContainer.appendChild(div); // Append the new div to the container
    });

    // Remove footer link on click
    footerContainer.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('remove-link')) {
            const footerItem = e.target.closest('.footer-item');
            if (footerItem) footerItem.remove();
        }
    });



    // For footer icon container
    let footerIconCounter = {{ count($footer->social_icon) }};
    const footerIconContainer = document.getElementById('footer-icon-container');

    document.getElementById('add-footer-icon').addEventListener('click', function() {

        const index = footerIconCounter;
        footerIconCounter++;

        const iconKey = `icon_${index+1}`;
        const linkKey = `link_icon_${index+1}`;

        const div = document.createElement('div');
        div.classList.add('col-3', 'my-2', 'footer-link');
        div.id = `footer-icon-${index}`;

        div.innerHTML = `<div class="border rounded p-3">
            <label>Social Link</label>
            <x-text-input type="text"
                name="social_icon[${index}][${linkKey}]"
                class="form-control mb-2"
                value="#" />

            <div x-data="{ imagePreview: null }"
                @click="$refs.image${index}.click()"
                class="ant-upload ant-upload-select-picture-card flex justify-center items-center cursor-pointer relative h-32 w-100">

                <input type="file"
                    name="social_icon[${index}][${iconKey}]"
                    class="hidden"
                    accept="image/*"
                    x-ref="image${index}"
                    @change="const f = $event.target.files[0]; if (f) imagePreview = URL.createObjectURL(f)" />

                <template x-if="imagePreview">
                    <img :src="imagePreview" class="absolute inset-0 object-cover w-100 h-100 rounded" />
                </template>

                <template x-if="!imagePreview">
                    <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                        style="height: 8rem; width:100%; background:black;">
                                        <span class="text-white">Click to upload</span>
                                        <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                            <div class="rounded flex items-center justify-center"
                                                style="height: 18%; width:8%; background-color: #fff">
                                                <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                            </div>
                                        </div>
                                    </div>
                </template>
            </div>

            <button type="button" class="btn btn-outline-danger w-100 mt-2"
                onclick="removeFooterIcon(${index})">
                Remove
            </button>
            </div>
        `;

        footerIconContainer.appendChild(div);
    });

    function removeFooterIcon(index) {
        const el = document.getElementById(`footer-icon-${index}`);
        if (el) el.remove();
    }



    let footerIndex = {{ count($footer->link) }};
    const container2 = document.getElementById('footer-link-container2');

    // Add new footer link
    document.getElementById('add-link').addEventListener('click', function() {
        footerIndex++;

        const div = document.createElement('div');
        div.classList.add('col-3', 'mb-4', 'footer-link-item');
        div.id = "footer-link-" + footerIndex;

        div.innerHTML = `
        <div class="border rounded p-3">

            <label>Contact Link</label>
            <x-text-input type="text"
                   name="link[${footerIndex}][link_${footerIndex}]"
                   class="form-control mb-2" />

            <label>Icon Image</label>
           <div x-data="{ imagePreview: null }" @click="$refs.image.click()"
                class="ant-upload ant-upload-select-picture-card flex flex-col justify-center items-center cursor-pointer relative h-32 w-100 image-preview">
                <input id="image" name="link[${footerIndex}][link_icon_${footerIndex}]" type="file"
                    class="hidden" accept="image/*" x-ref="image"
                    @change="const file = $event.target.files[0]; if (file) { imagePreview = URL.createObjectURL(file) }" />

                <template x-if="imagePreview">
                            <div class=" z-10 text-black rounded object-cover absolute flex items-center justify-center relative" style="height: 8rem; width:100%;">
                                <img :src="imagePreview" alt="Banner Preview" class="rounded object-cover absolute inset-0 w-100 h-100" />
                                    <div class="absolute inset-0 z-10 flex items-start justify-end">
                                        <div class="rounded flex items-center justify-center " style="height: 16%; width:4%; background-color: #fff">
                                            <img src="{{ asset('assets/images/image-plus.svg') }}" alt="">
                                    </div>
                                </div>
                            </div>
                        </template>
                        <template x-if="!imagePreview">
                                <div class="z-10 text-black rounded object-cover absolute flex items-center justify-center relative"
                                    style="height: 8rem; width:100%; background:black;">
                                    <span class="text-white">Click to upload</span>
                                    <div class="absolute inset-0 z-10 flex items-start justify-end p-1">
                                        <div class="rounded flex items-center justify-center"
                                            style="height: 18%; width:8%; background-color: #fff">
                                            <img src='{{ asset('assets/images/image-plus.svg') }}' alt="">
                                        </div>
                                    </div>
                                </div>
                        </template>
            </div>

            <button type="button"
                    class="btn btn-outline-danger btn-sm w-100 mt-2"
                    onclick="removeFooterLink(${footerIndex})">
                Remove
            </button>

        </div>
    `;
        container2.appendChild(div);
    });

    // Remove footer link
    function removeFooterLink(index) {
        const item = document.getElementById(`footer-link-${index}`);
        if (item) {
            item.remove();
        }
    }
</script>
