<?php
namespace App\Repositories;

use Abedin\Maker\Repositories\Repository;
use App\Models\WebSetting;
use Illuminate\Support\Facades\Storage;

class WebSettingRepository extends Repository
{
    public static function model()
    {
        return WebSetting::class;
    }

    public static function getType($type){
        return self::query()->where('key', $type)->first();
    }

    public static function processHeader($data,$request, $existingValue){
        $oldLogo  = json_decode($existingValue->value)->logo ?? null;
        $newLogo  = $request->file('logo');

        $logoPath = self::handleImage($newLogo, $oldLogo, 'logos');
        $jsonData = [
            'logo'        => $logoPath,
        ];

        return $jsonData;
    }

     public static function processBanner($data,$request, $existingValue){
        $existing = json_decode($existingValue->value ?? '{}', true);

        $imageGroups = self::handleImageArray($request->image_group ?? [],
            $existing['image_group'] ?? [],'banners/image_group','img'
        );

        $appStores = self::handleImageArray($request->app_store ?? [],$existing['app_store'] ?? [],'banners/app_store','thumb');

        $bannerThumbPath = self::handleImage($request->file('banner_thumb'),$existing['banner_thumb'] ?? null,'banners/thumb');

        $jsonData = [
            'image_group' => $imageGroups,
            'ratings'     => $request->input('ratings', $existing['ratings'] ?? ''),
            'reviews'     => $request->input('reviews', $existing['reviews'] ?? ''),
            'title'       => $request->input('title', $existing['title'] ?? ''),
            'description' => $request->input('description', $existing['description'] ?? ''),
            'app_store'   => $appStores,
            'banner_thumb'=> $bannerThumbPath,
        ];
        return $jsonData;
     }

    public static function processChooseSection($data, $request, $existingValue){
        $existing = json_decode($existingValue->value ?? '{}', true);

        $chooseThumbPath = self::handleImage(
            $request->file('choose_thumb'),
            $existing['choose_thumb'] ?? null,
            'choose/thumb'
        );

        $listItems = [];

        if ($request->has('list_item')) {
            $listItems = $request->has('list_item')
                ? self::handleImageArray($request->list_item, $existing['list_item'] ?? [], 'choose/list_item', 'thumb')
                : ($existing['list_item'] ?? []);
        } else {
            $listItems = $existing['list_item'] ?? [];
        }

        return [
            'choose_thumb' => $chooseThumbPath,
            'title'        => $request->input('title', $existing['title'] ?? ''),
            'description'  => $request->input('description', $existing['description'] ?? ''),
            'list_item'    => $listItems
        ];
    }

    public static function processAppSection($data, $request, $existingValue){
        $existing = json_decode($existingValue->value ?? '{}', true);

        $appStores = $request->has('app_section_store')
            ? self::handleImageArray($request->app_section_store, $existing['app_store'] ?? [], 'banners/app_store', 'thumb')
            : ($existing['app_store'] ?? []);

        $backgroundImage = self::handleImage($request->file('background_image') ?? null, $existing['background_image'] ?? null, 'banners/thumb');
        $appThumb = self::handleImage($request->file('app_thumb') ?? null, $existing['app_thumb'] ?? null, 'feature/background');

        return [
            'title'            => $request->input('title', $existing['title'] ?? ''),
            'description'      => $request->input('description', $existing['description'] ?? ''),
            'app_store'        => $appStores,
            'background_image' => $backgroundImage,
            'app_thumb'        => $appThumb
        ];
    }

    public static function processFeatureSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $backgroundPath = self::handleImage($request->file('background_image') ?? null, $existing['background_image'] ?? null, 'feature/background');
            $requestFeatureCards = $request->has('feature_card')
        ? array_values($request->feature_card)
        : [];

        $featureCards = !empty($requestFeatureCards)
            ? self::handleImageArray($requestFeatureCards, $existing['feature_card'] ?? [], 'feature/icons', 'icon_image')
            : ($existing['feature_card'] ?? []);

        foreach ($featureCards as $index => &$card) {
            $card['number'] = $requestFeatureCards[$index]['number'] ?? ($existing['feature_card'][$index]['number'] ?? '');
            $card['content_title'] = $requestFeatureCards[$index]['content_title'] ?? ($existing['feature_card'][$index]['content_title'] ?? '');
            $card['content_subtitle'] = $requestFeatureCards[$index]['content_subtitle'] ?? ($existing['feature_card'][$index]['content_subtitle'] ?? '');
        }

        return [
            'background_image' => $backgroundPath,
            'title'            => $request->input('title', $existing['title'] ?? ''),
            'sub_title'        => $request->input('sub_title', $existing['sub_title'] ?? ''),
            'description'      => $request->input('description', $existing['description'] ?? ''),
            'feature_card'     => $featureCards
        ];
    }

    public static function processDiscoverSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $backgroundPath = self::handleImage( $request->file('background_image') ?? null, $existing['background_image'] ?? null,'discover/background');
        $discoverPath = self::handleImage( $request->file('discover_thumb') ?? null, $existing['discover_thumb'] ?? null,'discover/thumb');

        return [
            'title'            => $request->input('title', $existing['title'] ?? ''),
            'description'      => $request->input('description', $existing['description'] ?? ''),
            'background_image' => $backgroundPath,
            'discover_thumb'   => $discoverPath,
        ];
    }

    public static function processWhoWeAreSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $thumbPath1 = self::handleImage(
            $request->file('thumb_1') ?? null,
            $existing['who'][0]['thumb_1'] ?? null,
            'who/thumb'
        );

        $thumbPath2 = self::handleImage(
            $request->file('thumb_2') ?? null,
            $existing['who'][1]['thumb_2'] ?? null,
            'who/thumb'
        );
        return [
            'who' => [
                0 => [
                    'title_1'       => $request->input('title_1', $existing['who'][0]['title_1'] ?? ''),
                    'description_1' => $request->input('description_1', $existing['who'][0]['description_1'] ?? ''),
                    'thumb_1'       => $thumbPath1,
                ],
                1 => [
                    'title_2'       => $request->input('title_2', $existing['who'][1]['title_2'] ?? ''),
                    'description_2' => $request->input('description_2', $existing['who'][1]['description_2'] ?? ''),
                    'thumb_2'       => $thumbPath2,
                ]
            ],
        ];
    }

    public static function processRegisterSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $backgroundPath = self::handleImage(
            $request->file('background_image') ?? null,
            $existing['background_image'] ?? null,
            'register/background'
        );

        $registerPath = self::handleImage(
            $request->file('register_thumb') ?? null,
            $existing['thumb'] ?? null,
            'register/thumb'
        );

        $buttonItems = [];
        foreach ($data as $key => $value) {

            if (str_starts_with($key, 'button_name_')) {
                preg_match('/button_name_(\d+)/', $key, $matches);
                $index = $matches[1] ?? null;
                if ($index) {
                    $buttonItems[$index]["button_name_{$index}"] = $value;
                }
            }
            if (str_starts_with($key, 'button_link_')) {
                preg_match('/button_link_(\d+)/', $key, $matches);
                $index = $matches[1] ?? null;
                if ($index) {
                    $buttonItems[$index]["button_link_{$index}"] = $value;
                }
            }
        }
        $buttonItems = array_values($buttonItems);
        foreach ($buttonItems as $i => &$button) {
            $values = array_values($button);
            $button = [
                "button_name_" . ($i + 1)      => $values[0] ?? '',
                "button_link_" . ($i + 1) => $values[1] ?? '',
            ];
        }

        return [
            'title'            => $request->input('title', $existing['title'] ?? ''),
            'sub_title'        => $request->input('sub_title', $existing['sub_title'] ?? ''),
            'description'      => $request->input('description', $existing['description'] ?? ''),
            'background_image' => $backgroundPath,
            'thumb'            => $registerPath,
            'button'           => $buttonItems,
        ];
    }

    public static function processTestimonialSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);
        $existingTestimonials = $existing['testimonial_content'] ?? [];

        $testimonialContent = [];
        $cleanInput = array_values($request->testimonial_content ?? []);
        $uploadedFiles = $request->file('testimonial_content') ?? [];

        foreach ($cleanInput as $newIndex => $item) {
            $number = $newIndex + 1;

            $titleKeyNew       = "title_{$number}";
            $ratingKeyNew      = "rating_{$number}";
            $dateKeyNew        = "date_{$number}";
            $descriptionKeyNew = "description_{$number}";
            $imageKeyNew       = "avatar_image_{$number}";

            $firstKey = array_key_first($item);
            preg_match('/_(\d+)$/', $firstKey, $matches);
            $originalNumber = intval($matches[1]);

            $titleKeyOld       = "title_{$originalNumber}";
            $ratingKeyOld      = "rating_{$originalNumber}";
            $dateKeyOld        = "date_{$originalNumber}";
            $descriptionKeyOld = "description_{$originalNumber}";
            $imageKeyOld       = "avatar_image_{$originalNumber}";

            $name        = $item[$titleKeyOld]       ?? '';
            $rating      = $item[$ratingKeyOld]      ?? '';
            $date        = $item[$dateKeyOld]        ?? '';
            $description = $item[$descriptionKeyOld] ?? '';

            $newUploadedImage = $uploadedFiles[$originalNumber][$imageKeyOld] ?? null;

            $oldImage = null;
            foreach ($existingTestimonials as $oldData) {
                if (isset($oldData[$imageKeyOld])) {
                    $oldImage = $oldData[$imageKeyOld];
                    break;
                }
            }

            $newUploadedImage1 = $uploadedFiles[$newIndex][$imageKeyOld] ?? null;
            if($newUploadedImage1){
                $avatarPath = self::handleImage(
                    $newUploadedImage1,
                    $oldImage,
                    'testimonials/avatars'
                );
            }else{
            $avatarPath = self::handleImage(
                    $newUploadedImage,
                    $oldImage,
                    'testimonials/avatars'
                );
            }

            $testimonialContent[$newIndex] = [
                $titleKeyNew        => $name,
                $ratingKeyNew       => $rating,
                $imageKeyNew        => $avatarPath,
                $dateKeyNew         => !empty($date) ? strtotime($date) : null,
                $descriptionKeyNew  => $description,
            ];
        }

        return [
            'title'               => $request->input('title', $existing['title'] ?? ''),
            'description'         => $request->input('description', $existing['description'] ?? ''),
            'testimonial_content' => $testimonialContent
        ];
    }

    public static function processAccordianSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $accordianContent = [];

        if ($request->has('accordian_items')) {
            $counter = 1;

            foreach ($request->accordian_items as $index => $accordian) {
                $accordianContent[] = [
                    'title_' . $counter   => $accordian['title'],
                    'content_' . $counter => $accordian['content'],
                ];
                $counter++;
            }
        } else {
            $accordianContent = $existing['accordian_items'] ?? [];
        }

        $accordianPath = self::handleImage($request->file('accordian_thumb') ?? null, $existing['accordian_thumb'] ?? null, 'accordian/thumb');

        return [
            'title'           => $request->input('title', $existing['title'] ?? ''),
            'sub_title'       => $request->input('sub_title', $existing['sub_title'] ?? ''),
            'accordian_thumb' => $accordianPath,
            'accordian_items' => $accordianContent,
        ];

    }

    public static function processFooterSection($data, $request, $existingValue)
    {
        $existing = json_decode($existingValue->value ?? '{}', true);

        $footerLinks = [];
        if ($request->has('footer_link')) {
            $counter = 1;
            foreach ($request->footer_link as $index => $link) {
                $footerLinks[] = [
                    'link_' . $counter    => $link['link'] ?? '',
                    'content_' . $counter => $link['content'] ?? '',
                ];
                $counter++;
            }
        }else {
            $footerLinks = $existing['footer_link'] ?? [];
        }

        $linkItems = [];

        if ($request->has('link')) {

            $serial = 1;

            foreach ($request->link as $reqIndex => $row) {
                $textKey = array_key_first($row);
                $textValue = $row[$textKey];

                $newTextKey = "link_" . $serial;
                $newIconKey = "link_icon_" . $serial;

                $oldIconKey = "link_icon_" . ($reqIndex + 1);
                $oldIcon = $existing['link'][$reqIndex][$oldIconKey] ?? null;

                if ($oldIcon === null) {
                    $oldIconKey = "link_icon_" . $reqIndex;
                    $oldIcon = $existing['link'][$reqIndex][$oldIconKey] ?? null;
                }

                if ($request->hasFile("link.$reqIndex.$oldIconKey")) {

                    if (!empty($oldIcon)) {
                        Storage::disk('public')->delete($oldIcon);
                    }

                    $iconPath = $request->file("link.$reqIndex.$oldIconKey")
                                            ->store('footer/icons', 'public');

                } else {

                    $iconPath = $oldIcon;
                }

                $linkItems[] = [
                    $newTextKey => $textValue,
                    $newIconKey => $iconPath
                ];

                $serial++;
            }
        } else {

            $linkItems = $existing['link'] ?? [];
        }

        $socialIcons = [];
        if ($request->has('social_icon')) {

            $serial = 1;
            foreach ($request->social_icon as $reqIndex => $row) {
                $textKey = array_key_first($row);
                $textValue = $row[$textKey];

                $newTextKey = "link_icon_" . $serial;
                $newIconKey = "icon_" . $serial;

                $oldIconKey = "icon_" . ($reqIndex + 1);
                $oldIcon = $existing['social_icon'][$reqIndex][$oldIconKey] ?? null;

                if ($oldIcon === null) {
                    $oldIconKey = "icon_" . $reqIndex;
                    $oldIcon = $existing['social_icon'][$reqIndex][$oldIconKey] ?? null;
                }

                if ($request->hasFile("social_icon.$reqIndex.$newIconKey")) {
                    if (!empty($oldIcon)) {
                        Storage::disk('public')->delete($oldIcon);
                    }
                    $iconPath = $request->file("social_icon.$reqIndex.$newIconKey")
                                            ->store('footer/icons', 'public');
                } else {
                    $iconPath = $oldIcon;
                }

                $socialIcons[] = [
                    $newTextKey => $textValue,
                    $newIconKey => $iconPath
                ];
                $serial++;
            }
        } else {
            $socialIcons = $existing['social_icon'] ?? [];
        }


        $footerText = $request->input('footer_text', $existing['footer_text'] ?? '');
        $description = $request->input('description', $existing['description'] ?? '');
        $footerLogo = self::handleImage($request->file('footer_logo') ?? null, $existing['footer_logo'] ?? null, 'accordian/thumb');
        return [
            'footer_logo'  => $footerLogo,
            'description'  => $description,
            'footer_text'  => $footerText,
            'footer_link'  => $footerLinks,
            'link'         => $linkItems,
            'social_icon'  => $socialIcons,
        ];
    }

    public static function handleImage($newFile, $oldFilePath, $directory)
    {
        if ($newFile instanceof \Illuminate\Http\UploadedFile) {
            if (!empty($oldFilePath) && Storage::disk('public')->exists($oldFilePath)) {
                Storage::disk('public')->delete($oldFilePath);
            }
            return $newFile->store($directory, 'public');
        }
        return $oldFilePath;
    }

    public static function handleImageArray($requestArray, $existingArray, $directory, $fieldName = 'img')
    {
        $result = [];

        foreach ($requestArray as $index => $item) {

            $newFile = $item[$fieldName] ?? null;
            $oldFile = $existingArray[$index][$fieldName] ?? null;
            $path = self::handleImage($newFile, $oldFile, $directory);

            $result[$index] = $existingArray[$index] ?? [];
            foreach ($item as $key => $value) {
                $result[$index][$key] = $value;
            }

            $result[$index][$fieldName] = $path;
        }

        return array_values($result);
    }

}

