<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Repositories\WebSettingRepository;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class WebSettingController extends Controller
{

    public function index(): View
    {
        $webSettings = WebSettingRepository::getAll();
        foreach ($webSettings as $setting) {
            $decoded = json_decode($setting->value);
            $setting->decoded_value = $decoded;
            $setting->key = $setting->key ?? null;
        }

        return view('web-settings.index', compact('webSettings'));
    }
    public function update(Request $request, $type)
    {
        $existingValue = WebSettingRepository::getType($type);
        $title = $request->title;

        $title = preg_replace('/<\/p>\s*<p>/', '<br>', $title);

        $title = str_replace(['<p>', '</p>'], '', $title);

        $request['title'] = strip_tags($title, '<br>');

        $data = $request->except('_token');

        $handlers = [
            'header' => 'processHeader',
            'banner' => 'processBanner',
            'choose_section' => 'processChooseSection',
            'app_section' => 'processAppSection',
            'feature_section' => 'processFeatureSection',
            'discover_section' => 'processDiscoverSection',
            'who_we_are' => 'processWhoWeAreSection',
            'register_section' => 'processRegisterSection',
            'testimonial_section' => 'processTestimonialSection',
            'accordian_section' => 'processAccordianSection',
            'footer' => 'processFooterSection',
        ];
        $method = $handlers[$type];
        $jsonData = WebSettingRepository::$method($data,$request, $existingValue);

        $existingValue->value = json_encode($jsonData, JSON_UNESCAPED_SLASHES);
        $existingValue->save();

        return redirect()->back()->with('success', 'Web settings updated successfully.');

    }

}
