<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleBrand extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'vehicle_category_id'
    ];

    public function category(): BelongsTo
{
    return $this->belongsTo(VehicleCategory::class,'vehicle_category_id');
}
}
