<?php

namespace App\Enums;

use App\Enums\Attributes\EnumAttributes;

enum PaymentType: string
{
    use EnumAttributes;

    case RAZORPAY = 'razorpay';
    case STRIPE = 'stripe';
    case PAYSTACK = 'paystack';
    case PAYPAL = 'paypal';
    case PAYFAST = 'payfast';
    case FLUTTERWAVE = 'flutterwave';
    case CASH = 'cash';
    // case BOTH = 'both';


    public static function cashAndCredit(): array
    {
        return [
            self::RAZORPAY,
            self::STRIPE,
            self::PAYSTACK,
            self::PAYPAL,
            self::PAYFAST,
            self::FLUTTERWAVE,
            self::CASH,
        ];
    }

    public function label(): string
    {
        return match ($this) {
            self::RAZORPAY => 'Razorpay',
            self::STRIPE => 'Stripe',
            self::PAYSTACK => 'Paystack',
            self::PAYPAL => 'Paypal',
            self::PAYFAST => 'Payfast',
            self::FLUTTERWAVE => 'Flutterwave',
            self::CASH => 'Cash',
        };
    }

    public static function options(): array
    {
        return collect(self::cases())->mapWithKeys(function ($case) {
            return [$case->value => [
                'value' => $case->value,
                'name' => $case->label(),
            ]];
        })->toArray();
    }
}
